import { Ref, ref } from "vue";
import {
    AvailableWidgets,
    Color,
    ColorPalette,
    EmptySearchTerm,
    ErrorMessage,
    LoadingState,
    LockedState,
    ModalOpenState,
    NoErrorMessage,
    PageKey,
    PageStyle,
    PageTranslations,
    RefreshButtonDropupOpenState,
    RefreshInterval,
    RefreshIntervalLoop,
    RefreshIntervals,
    UnselectedAvailableWidget,
    UnselectedRefreshInterval,
    UnselectedWidget,
    Widget,
    Widgets,
} from "./type";
import { FIFTEEN_MINUTES, FIVE_MINUTES, ONE_HOUR, ONE_MINUTE, THIRTY_MINUTES } from "./data/times";
import {
    APEXCHART_BLUE,
    APEXCHART_GRAY,
    APEXCHART_GREEN,
    APEXCHART_MAGENTA,
    APEXCHART_ORANGE,
    GAMBIO_BLUE,
    GAMBIO_GRAY,
    GAMBIO_YELLOW,
} from "./data/colors";

export const UNSELECTED_AVAILABLE_WIDGET: UnselectedAvailableWidget = {};
export const UNSELECTED_WIDGET: UnselectedWidget = {};
export const NO_ERROR_MESSAGE: NoErrorMessage = "";
export const EMPTY_SEARCH_TERM: EmptySearchTerm = "";
export const UNSELECTED_REFRESH_INTERVAL: UnselectedRefreshInterval = 0;

export const translations: PageTranslations = window.jsEnvironment.vuePage.translations as PageTranslations;

export const widgets: Ref<Widgets> = ref([]);
export const availableWidgets: Ref<AvailableWidgets> = ref([]);

export const isLocked: Ref<LockedState> = ref(true);
export const isLoading: Ref<LoadingState> = ref(true);

export const isAddWidgetModalOpen: Ref<ModalOpenState> = ref(false);
export const isEditWidgetModalOpen: Ref<ModalOpenState> = ref(false);
export const isDeleteWidgetModalOpen: Ref<ModalOpenState> = ref(false);
export const isErrorModalOpen: Ref<ModalOpenState> = ref(false);

export const refreshInterval: Ref<RefreshInterval | UnselectedRefreshInterval> = ref(UNSELECTED_REFRESH_INTERVAL);
export const widgetLoading: Ref<Widget | UnselectedWidget> = ref(UNSELECTED_WIDGET);
export const widgetBeingEdited: Ref<Widget | UnselectedWidget> = ref(UNSELECTED_WIDGET);
export const widgetBeingDeleted: Ref<Widget | UnselectedWidget> = ref(UNSELECTED_WIDGET);
export const errorMessageBeingShown: Ref<ErrorMessage> = ref(NO_ERROR_MESSAGE);

export const chartForegroundColor: Color = GAMBIO_GRAY;
export const chartColorPalette: ColorPalette = [
    GAMBIO_BLUE,
    APEXCHART_BLUE,
    APEXCHART_GREEN,
    APEXCHART_GRAY,
    APEXCHART_MAGENTA,
    APEXCHART_ORANGE,
    GAMBIO_YELLOW,
];

export const availableRefreshIntervals: Ref<RefreshIntervals> = ref([
    UNSELECTED_REFRESH_INTERVAL,
    ONE_MINUTE,
    FIVE_MINUTES,
    FIFTEEN_MINUTES,
    THIRTY_MINUTES,
    ONE_HOUR,
]);

export const pageKey: Ref<PageKey> = ref(Date.now());
export const pageStyle: Ref<PageStyle> = ref({
    width: "100%",
    height: "100%",
});

export const refreshIntervalLoop: Ref<RefreshIntervalLoop> = ref();

export const isSmallScreen = ref(window.innerWidth <= 1024);

export const titleBarHeight = ref(40);
